#ifndef JOB_QUEUE_H
#define JOB_QUEUE_H

#include <stdbool.h>

#include "global_types.h"
#include "model/kmodule.h"

error_code_t job_scheduler_init(void);

void job_scheduler_deinit(void);

error_code_t job_scheduler_schedule_module(const char *module_name_or_path, const char *module_params);

error_code_t job_scheduler_schedule_depmods(kmodule_t *kmodule, int *depmod_scheduled_cnt_ptr);

error_code_t job_scheduler_process_modules(void);

bool job_scheduler_is_done(void);

#endif
